<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('training_requests', function (Blueprint $table) {
        $table->id();
        $table->foreignId('user_id')->constrained()->onDelete('cascade');

        $table->string('title');                 // judul training
        $table->text('description')->nullable(); // tujuan / detail
        $table->date('training_date');           // tanggal
        $table->string('vendor')->nullable();    // penyelenggara

        $table->enum('status', [
            'draft',
            'submitted',
            'approved_hrd',
            'rejected_hrd',
        ])->default('submitted');

        $table->text('hrd_notes')->nullable();   // catatan HRD
        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('training_requests');
    }
};
